/* ========================================================================

LawMatics: Main.js ( Main Theme JS file )

Theme Name: LawMatics - Creative Law Firm and Attorney Landing Page
Version: 1.0
Author: Raven Themez
Author URI: http://themeforest.net/user/raventhemez
If you having trouble in editing js. please send a mail to raventhemez@gmail.com

=========================================================================
 */


"use strict";


/*======== Doucument Ready Function =========*/
jQuery(document).ready(function () {

    //CACHE JQUERY OBJECTS
    var $window = $(window);

    $window.on( 'load', function () {
        /*======== Preloader =========*/
        $(".loading-text").fadeOut();
        $(".loading").delay(350).fadeOut("slow");
        /* END of Preloader */

        $('.banner-caption').addClass('animation');

        /*========= Masonry Grid Script ==========*/
        $(".grid-masonry").masonry({
            // options...
            itemSelector: ".grid-item",
            columnWidth: ".grid-item",

        });
        /*========== End Masonry Grid ==========*/

        /*========== Init Wow ==========*/
        new WOW().init();
        /*========== End Init Wow ==========*/

    });

    /*========== sticky header ==========*/

    $window.on("resize", function () {
        $(".navbar-collapse").css({maxHeight: $window.height() - $(".navbar-header").height() + "px"});
    });

    $(".sticky-header").sticky({topSpacing: 0});

    /*========== End sticky header ==========*/

    /*======== Menu Init =========*/

    if ($window.width() > 767) {
        $(".dropdown").on('mouseenter', function(){
            $('.dropdown-menu', this).not('.in .dropdown-menu').stop(true, true).slideDown(200);
            $(this).toggleClass('open');
        });
        $(".dropdown").on('mouseleave', function(){
            $('.dropdown-menu', this).not('.in .dropdown-menu').stop(true, true).slideUp(200);
            $(this).toggleClass('open');
        });
    }

    /*======== End Menu Init =========*/

    /*======= Banner Resize with window size =========*/

    $window.on( 'resize', function () {
        var bodyheight = $(this).height();
        $("#rt_banner").height(bodyheight);
    }).resize();

    /*======= End Banner Resize with window size =========*/

    /*======= Main Slider Init =========*/

    var interleaveOffset = 0.5;
    var swiperOptions = {
        loop: true,
        speed: 1000,
        grabCursor: true,
        watchSlidesProgress: true,
        mousewheelControl: true,
        keyboardControl: true,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev"
        },
        on: {
            progress: function() {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    var slideProgress = swiper.slides[i].progress;
                    var innerOffset = swiper.width * interleaveOffset;
                    var innerTranslate = slideProgress * innerOffset;
                    swiper.slides[i].querySelector(".slide-inner").style.transform =
                        "translate3d(" + innerTranslate + "px, 0, 0)";
                }
            },
            touchStart: function() {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    swiper.slides[i].style.transition = "";
                }
            },
            setTransition: function(speed) {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    swiper.slides[i].style.transition = speed + "ms";
                    swiper.slides[i].querySelector(".slide-inner").style.transition =
                        speed + "ms";
                }
            }
        }
    };
    var swiper = new Swiper(".swiper-container", swiperOptions);

    /*======= End Main Slider Init =========*/

    /*========= Fun and Facts Script ======== */

    try {
        $(".fun-facts_wrapper").appear(function () {
            $(".timer").countTo();
        });
    } catch (err) {

        console.log(err.message);
    }

    /*========= End Fun and Facts Script ======== */

    /*======== One Page Scrolling ======= */

    $(".main-nav").onePageNav({
        currentClass: "active",
        changeHash: true,
        scrollSpeed: 1000,
        scrollThreshold: 0.5,
        filter: "",
        easing: "swing",
        begin: function () {
            //I get fired when the animation is starting
        },
        end: function () {
            //I get fired when the animation is ending
        },
        scrollChange: function ($currentListItem) {
            //I get fired when you enter a section and I pass the list item of the section
        }
    });

    $( 'a[href*=#]:not([href=#])' ).on('click', function(e){
        e.preventDefault();
        if( location.pathname.replace( /^\// , '' ) == this.pathname.replace( /^\// , '' ) && location.hostname == this.hostname )
        {
            var target = $( this.hash );
            if( target.length )
            {
                $( 'html,body' ).stop().animate(
                {
                    scrollTop:target.offset().top - 80
                } , 1000 );
                return false;
            }
        }
    });

    /*======== End One Page Scrolling ========*/

    /*======== Contact Form ========*/

    $('#submit-btn').on('click',function (event){
        event.preventDefault();
        $.ajax({
            dataType: 'JSON',
            url: 'sendmail.php',
            type: 'POST',
            data: $('#contact_form').serialize(),
            beforeSend: function (xhr) {
                $('.mt_load').show();
            },
            success: function (response) {
                if (response) {
                    console.log(response);
                    if (response['signal'] == 'ok') {
                        toastr.success(response['msg']);
                        $('#msg').hide();
                        $('input, textarea').val(function () {
                            return this.defaultValue;
                        });
                    }
                    else {
                        $('#msg').show();
                        $('#msg').html('<div class="mt_error">'+ response['msg'] +'</div>');
                    }
                }
            },
            error: function () {
                $('#msg').show();
                $('#msg').html('<div class="mt_error">Errors occur. Please try again later.</div>');
            },
            complete: function () {
                $('.mt_load').hide();
            }
        });
    });
    /*======== End Contact Form ========*/


    /*======== Fancy Box Init ========*/

    var FancYB = $('.fancybox');
    FancYB.fancybox({
        openEffect: 'fade',
        closeEffect: 'fade',
        padding : 0,
        closeBtn: true,
        helpers: {
            title: {
                type: 'inside'
            },
            overlay: {
              locked: false
            },
            buttons: {}
        }
    });
    FancYB.attr('rel','gallery');

    /*======== End Fancy Box ========*/

    /*======== Brand Slider =========*/

    $("#mt_client .owl-carousel").owlCarousel({
        loop: false,
        margin: 24,
        autoplay: false,
        autoplayHoverPause: true,
        autoplaySpeed: 1000,
        dot: true,
        smartSpeed:850,
        responsive: {
            0: {
                items: 1,
                dots: true
            },
            600: {
                items: 3,
                dots: true
            },
            1000: {
                items: 5,
                dots: true
            },
            1201: {
                items: 5,
                dots: true
            }
        }
    });
    /*======== End Brand Slider =========*/

    /*======== Team Section =========*/
    $(".rt_team .owl-carousel").owlCarousel({
        loop: false,
        autoplay: true,
        autoplayHoverPause: true,
        autoplaySpeed: 1000,
        smartSpeed:850,
        dots: true,
        responsive: {
            0: {
                items: 1,
                dots: true
            },
            450: {
                items: 1,
                dots: true
            },
            500: {
                items: 1,
                dots: true
            },
            700: {
                items: 2,
                dots: true
            },
            1000: {
                items: 3,
                dots: true
            },
            1201: {
                items: 3,
                dots: true
            }
        }
    });

    /*======== End Team Section =========*/

    /*======== Testimonial Section =========*/

    $(".rt_testimonial .owl-carousel").owlCarousel({
        loop: false,
        margin: 24,
        autoplay: false,
        autoplayHoverPause: true,
        autoplaySpeed: 1000,
        dot: true,
        smartSpeed:850,
        responsive: {
            0: {
                items: 1,
                dots: true
            },
            600: {
                items: 1,
                dots: true
            },
            1000: {
                items: 2,
                dots: true
            },
            1201: {
                items: 2,
                dots: true
            }
        }
    });

    /*======== End Testimonial Section =========*/

});
/*======== End Doucument Ready Function =========*/